using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var moves = new List<(int x, int y)>();
        
        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split();
            int x = int.Parse(parts[0]);
            int y = int.Parse(parts[1]);
            moves.Add((x, y));
        }

        long X = 0, Y = 0;

        List<int> selectedMoves = new List<int>();
        long maxDist = 0;

        for (int i = 0; i < n; i++)
        {
            var (dx, dy) = moves[i];
            long newX = X + dx;
            long newY = Y + dy;
            long distance = newX * newX + newY * newY; 

            if (distance > maxDist)
            {
                maxDist = distance;
                selectedMoves.Clear(); 
                selectedMoves.Add(i + 1); 
                X = newX;
                Y = newY;
            }
        }

        Console.WriteLine(selectedMoves.Count);
        Console.WriteLine(string.Join(" ", selectedMoves));
    }
}